/*  4space, Copyright (c) 1995 Jacob Mandelson <jlm@ugcs.caltech.edu> 
 * Derived from the hypercube screensaver
 *  xscreensaver, Copyright (c) 1992 Jamie Zawinski <jwz@mcom.com>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 *
 * This code derived from TI Explorer Lisp code by Joe Keane, Fritz Mueller,
 * and Jamie Zawinski.
 */

#include <math.h>
#include "screenhack.h"

static Display *dpy;
static Window window;
static GC color[8];
static GC black;

static int delay;

static int observer_z;
static int x_offset, y_offset;
static int unit_pixels;

struct point_state {
  int old_x, old_y;
  int new_x, new_y;
  Bool same_p;
};

static struct point { double x, y, z, w; } *point;

static struct line { int point1, point2;
                     int color; } *line;

static int numpoints;
static int numlines;

static void
move_line (state0, state1, gc)
     struct point_state *state0, *state1;
     GC gc;
{
  if (state0->same_p && state1->same_p)
    return;
  if (mono_p)
    {
      XDrawLine (dpy, window, black,
		 state0->old_x, state0->old_y, state1->old_x, state1->old_y);
      XDrawLine (dpy, window, gc,
		 state0->new_x, state0->new_y, state1->new_x, state1->new_y);
    }
  else
    {
      XSegment segments [2];
      segments [0].x1 = state0->old_x; segments [0].y1 = state0->old_y;
      segments [0].x2 = state1->old_x; segments [0].y2 = state1->old_y;
      segments [1].x1 = state0->new_x; segments [1].y1 = state0->new_y;
      segments [1].x2 = state1->new_x; segments [1].y2 = state1->new_y;
      XDrawSegments (dpy, window, gc, segments, 2);
    }
}

static void
remove_line (state0, state1, gc)
     struct point_state *state0, *state1;
     GC gc;
{
  if (mono_p)
    {
      XDrawLine (dpy, window, black,
		 state0->old_x, state0->old_y, state1->old_x, state1->old_y);
    }
  else
    {
      XSegment segments [1];
      segments [0].x1 = state0->new_x; segments [0].y1 = state0->new_y;
      segments [0].x2 = state1->new_x; segments [0].y2 = state1->new_y;
      XDrawSegments (dpy, window, gc, segments, 1);
    }
}

static void
hyper (xy, xz, yz, xw, yw, zw)
     double xy, xz, yz, xw, yw, zw;
{
  double cos_xy = cos (xy), sin_xy = sin (xy);
  double cos_xz = cos (xz), sin_xz = sin (xz);
  double cos_yz = cos (yz), sin_yz = sin (yz);
  double cos_xw = cos (xw), sin_xw = sin (xw);
  double cos_yw = cos (yw), sin_yw = sin (yw);
  double cos_zw = cos (zw), sin_zw = sin (zw);

  double ax = 1.0, ay = 0.0, az = 0.0, aw = 0.0;
  double bx = 0.0, by = 1.0, bz = 0.0, bw = 0.0;
  double cx = 0.0, cy = 0.0, cz = 1.0, cw = 0.0;
  double dx = 0.0, dy = 0.0, dz = 0.0, dw = 1.0;

  double _tmp0_, _tmp1_;

  int i;

  struct point_state *points ;
  points = calloc(numpoints, sizeof(struct point_state));


  while (1)
    {
      double temp_mult;
      XEvent event;

#define compute(a,b,c,d,point_state) \
      temp_mult = (unit_pixels / (((a*az) + (b*bz) + (c*cz) + (d*dz) +	  \
				   (a*aw) + (b*bw) + (c*cw) + (d*dw))	  \
				  - observer_z));			  \
  point_state.old_x = point_state.new_x;				  \
  point_state.old_y = point_state.new_y;				  \
  point_state.new_x = ((((a*ax) + (b*bx) + (c*cx) + (d*dx)) * temp_mult) \
			+ x_offset);					  \
  point_state.new_y = ((((a*ay) + (b*by) + (c*cy) + (d*dy)) * temp_mult) \
			+ y_offset);					  \
  point_state.same_p = (point_state.old_x == point_state.new_x &&	  \
			 point_state.old_y == point_state.new_y);

      for (i=0; i<numpoints; i++)
        { compute(point[i].x, point[i].y, point[i].z, point[i].w,
                  points[i]);
        }
   
      for (i=0; i<numlines; i++)
        { move_line (&points[line[i].point1],
                     &points[line[i].point2], color[line[i].color]);
        }

 /* If you get error messages about the following forms, and you think you're
    using an ANSI C conforming compiler, then you're mistaken.  Possibly you're
    mixing an ANSI compiler with a non-ANSI preprocessor, or vice versa.
    Regardless, your system is broken; it's not a bug in this program.
  */
#if __STDC__
# define rotate(name,dim0,dim1,cos,sin) \
      _tmp0_ = ((name##dim0 * cos) + (name##dim1 * sin)); \
      _tmp1_ = ((name##dim1 * cos) - (name##dim0 * sin)); \
      name##dim0 = _tmp0_; \
      name##dim1 = _tmp1_;

# define rotates(dim0,dim1) \
      if (sin_##dim0##dim1 != 0) {				   \
        rotate(a, dim0, dim1, cos_##dim0##dim1, sin_##dim0##dim1); \
        rotate(b, dim0, dim1, cos_##dim0##dim1, sin_##dim0##dim1); \
        rotate(c, dim0, dim1, cos_##dim0##dim1, sin_##dim0##dim1); \
        rotate(d, dim0, dim1, cos_##dim0##dim1, sin_##dim0##dim1); \
      }

#else /* !__STDC__, courtesy of Andreas Luik <luik@isa.de> */
# define rotate(name,dim0,dim1,cos,sin) \
      _tmp0_ = ((name/**/dim0 * cos) + (name/**/dim1 * sin)); \
      _tmp1_ = ((name/**/dim1 * cos) - (name/**/dim0 * sin)); \
      name/**/dim0 = _tmp0_; \
      name/**/dim1 = _tmp1_;

# define rotates(dim0,dim1) \
      if (sin_/**/dim0/**/dim1 != 0) {				       \
        rotate(a,dim0,dim1,cos_/**/dim0/**/dim1,sin_/**/dim0/**/dim1); \
        rotate(b,dim0,dim1,cos_/**/dim0/**/dim1,sin_/**/dim0/**/dim1); \
        rotate(c,dim0,dim1,cos_/**/dim0/**/dim1,sin_/**/dim0/**/dim1); \
        rotate(d,dim0,dim1,cos_/**/dim0/**/dim1,sin_/**/dim0/**/dim1); \
      }
#endif /* !__STDC__ */

      rotates (x,y);
      rotates (x,z);
      rotates (y,z);
      rotates (x,w);
      rotates (y,w);
      rotates (z,w);

      event.type = LASTEvent;
      while (XCheckTypedEvent(dpy, Expose, &event))
          ;
      if (event.type == Expose)
      {   XClearWindow(dpy, window);
          for (i=0; i<numlines; i++)
            { remove_line (&points[line[i].point1],
                           &points[line[i].point2], color[line[i].color]);
            }
      }
      /* XSync (dpy, True); */
      if (delay) usleep (delay);
    }
}


char *progclass = "Fourspace";

char *defaults [] = {
  "Fourspace.background:	black",		/* to placate SGI */
  "Fourspace.foreground:	white",
  "*color0:	red",
  "*color1:	orange",
  "*color2:	yellow",
  "*color3:	white",
  "*color4:	green",
  "*color5:	cyan",
  "*color6:	dodgerblue",
  "*color7:	magenta",

  "*xw:		0.000",
  "*xy:		0.010",
  "*xz:		0.005",
  "*yw:		0.010",
  "*yz:		0.000",
  "*zw:		0.000",

  "*observer-z:	5",
  "*delay:	100000",
  0
};

XrmOptionDescRec options [] = {
  { "-color0",		".color0",	XrmoptionSepArg, 0 },
  { "-color1",		".color1",	XrmoptionSepArg, 0 },
  { "-color2",		".color2",	XrmoptionSepArg, 0 },
  { "-color3",		".color3",	XrmoptionSepArg, 0 },
  { "-color4",		".color4",	XrmoptionSepArg, 0 },
  { "-color5",		".color5",	XrmoptionSepArg, 0 },
  { "-color6",		".color6",	XrmoptionSepArg, 0 },
  { "-color7",		".color7",	XrmoptionSepArg, 0 },

  { "-xw",		".xw",		XrmoptionSepArg, 0 },
  { "-xy",		".xy",		XrmoptionSepArg, 0 },
  { "-xz",		".xz",		XrmoptionSepArg, 0 },
  { "-yw",		".yw",		XrmoptionSepArg, 0 },
  { "-yz",		".yz",		XrmoptionSepArg, 0 },
  { "-zw",		".zw",		XrmoptionSepArg, 0 },

  { "-observer-z",	".observer-z",	XrmoptionSepArg, 0 },
  { "-delay",		".delay",	XrmoptionSepArg, 0 },
  { 0, 0, 0, 0 }
};

int options_size = (sizeof (options) / sizeof (options[0])) - 1;


void
screenhack (d, w)
     Display *d;
     Window w;
{
  XGCValues gcv;
  XWindowAttributes xgwa;
  Colormap cmap;
  double xy, xz, yz, xw, yw, zw;
  unsigned long bg;

  dpy = d;
  window = w;
  XGetWindowAttributes (dpy, window, &xgwa);
  XSelectInput(dpy, window, xgwa.your_event_mask | ExposureMask);
  cmap = xgwa.colormap;

  x_offset = xgwa.width / 2;
  y_offset = xgwa.height / 2;
  unit_pixels = xgwa.width < xgwa.height ? xgwa.width : xgwa.height;

  xy = get_float_resource ("xy", "Float");
  xz = get_float_resource ("xz", "Float");
  yz = get_float_resource ("yz", "Float");
  xw = get_float_resource ("xw", "Float");
  yw = get_float_resource ("yw", "Float");
  zw = get_float_resource ("zw", "Float");

  observer_z = get_integer_resource ("observer-z", "Integer");

  delay = get_integer_resource ("delay", "Integer");

  bg = get_pixel_resource ("background", "Background", dpy, cmap);

  if (mono_p)
    {
      gcv.function = GXcopy;
      gcv.foreground = bg;
      black = XCreateGC (dpy, window, GCForeground|GCFunction, &gcv);
      gcv.foreground = get_pixel_resource ("foreground", "Foreground",
                                           dpy, cmap);
      color[0] = color[1] = color[2] = color[3] = color[4] = color[5] =
        color[6] = color[7] =
          XCreateGC (dpy, window, GCForeground|GCFunction, &gcv);
    }
  else
    {
      black = 0;
      gcv.function = GXxor;
#define make_gc(color,name) \
	gcv.foreground = bg ^ get_pixel_resource ((name), "Foreground", \
						  dpy, cmap);		\
	color = XCreateGC (dpy, window, GCForeground|GCFunction, &gcv)

      make_gc (color[0],"color0");
      make_gc (color[1],"color1");
      make_gc (color[2],"color2");
      make_gc (color[3],"color3");
      make_gc (color[4],"color4");
      make_gc (color[5],"color5");
      make_gc (color[6],"color6");
      make_gc (color[7],"color7");
    }

  { int i;
    scanf("%d", &numpoints);
    point = malloc(numpoints * sizeof(struct point));
    for (i=0; i<numpoints; i++)
      scanf("%lf%lf%lf%lf", &point[i].x, &point[i].y, &point[i].z, &point[i].w);
    scanf("%d", &numlines);
    line = malloc(numlines * sizeof(struct line));
    for (i=0; i<numlines; i++)
      scanf("%d%d%d", &line[i].point1, &line[i].point2, &line[i].color);
  }

  hyper (xy, xz, yz, xw, yw, zw);
}
