#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

XSegment segments[3];

static Display *dpy;
static Window window;
static GC fgcolor;

char *progclass = "Test";

unsigned int ColorOf(Display *d, Colormap map, char *name);

void sh()
{
    XGCValues gcv;
    XWindowAttributes xgwa;
    Colormap cmap;
    
    XGetWindowAttributes(dpy, window, &xgwa);
    cmap = xgwa.colormap;

    gcv.function = GXxor;
    gcv.foreground = ColorOf(dpy, cmap, "yellow");
    fgcolor = XCreateGC (dpy, window, GCForeground|GCFunction, &gcv);

    XDrawSegments(dpy, window, fgcolor, &segments[0], 1);
    XDrawSegments(dpy, window, fgcolor, &segments[0], 2);
    XDrawSegments(dpy, window, fgcolor, &segments[1], 2);
    XSync(dpy, True);
    while (1) sleep(1000);
}

unsigned int ColorOf(Display *d, Colormap map, char *name)
{
    XColor color;

    if (!XParseColor(d, map, name, &color)) {
	fprintf(stderr, "Can't parse color %s", name);
	goto ERR;
    }
    if (!XAllocColor(d, map, &color)) {
	fprintf(stderr, "Can't allocate color %s\n", name);
	goto ERR;
    }
    return color.pixel;

    ERR:
	return BlackPixel(d, DefaultScreen(d));
}
    
char *defaults[] = {
	".background:	black",
	".foreground:	yellow",
	0
};

int main(int argc, char *argv[]) {
    Widget toplevel;
    XtAppContext app;
    Colormap cmap;

    segments[0].x1 = 351; segments[0].y1 = 183;
    segments[0].x2 = 351; segments[0].y2 = 90;
    segments[1].x1 = 350; segments[1].y1 = 184;
    segments[1].x2 = 350; segments[1].y2 = 90;
    segments[2].x1 = 350; segments[2].y1 = 184;
    segments[2].x2 = 348; segments[2].y2 = 90;

    toplevel = XtAppInitialize(&app, progclass, NULL, 0, 
				&argc, argv, defaults, 0, 0);
    dpy = XtDisplay(toplevel);

    toplevel->core.width = 600;
    toplevel->core.height = 480;
    XtRealizeWidget(toplevel);
    window = XtWindow(toplevel);
    cmap = DefaultColormap(dpy, DefaultScreen(dpy));
    XSetWindowBackground(dpy, window, ColorOf( dpy, cmap, "black"));
    XtPopup(toplevel, XtGrabNone);
    XClearWindow(dpy, window);
    XSync(dpy, False);
    sh();
}
