#include "gale/all.h"
#include <signal.h>

/* Copyright (C) 2000
 *   Jacob L. Mandelson
 *  Licenced under the GNU General Public Licence.
 *  This code is available without charge, but lacks warranty.
 *   See the GPL for details.
 */ 

oop_source_sys *sys;
oop_source *source;
struct gale_link *conn1, *conn2;
struct gale_server *server1, *server2;
int is_done;

typedef struct {
    struct gale_link *conn;
    struct gale_text sub;
} srvinfo;

void loop(struct gale_message*, struct gale_text);
struct gale_text cat_append(struct gale_text, struct gale_text);

void *on_disconnect(struct gale_server *server, void *data) 
{
    fprintf(stderr, "Disconnected!\n");
    return OOP_CONTINUE;
}

void *on_message(struct gale_link *link, struct gale_message *msg, void *data)
{
    struct gale_fragment throwaway;
    if (!gale_group_lookup(msg->data, gale_text_concat(2, G_("gateway/"), 
				gale_var(G_("GALE_DOMAIN"))), 
			   frag_text, &throwaway)) {
	loop(msg, ((srvinfo*)data)->sub);
	link_put(((srvinfo*)data)->conn, msg);
    }
    /* else we've already gatewayed it */
    return OOP_CONTINUE;
}

void *on_connected(struct gale_server *server, struct gale_text host, 
		   struct sockaddr_in addr, void *d)
{
    gale_alert(GALE_NOTICE, gale_text_to_local(gale_text_concat(2,
				G_("connected to "),
				gale_connect_text(host, addr))), 0);
    return OOP_CONTINUE;
}

void *on_signal(oop_source *source, int sig, void *data) 
{
    is_done = 1;
    return OOP_HALT;
}

int prefix_match(struct gale_text cat, struct gale_text sub)
{
    return !gale_text_compare(gale_text_left(cat, sub.l), sub);
}

/* Add "Loop" fragment to message */
void loop(struct gale_message *msg, struct gale_text subs)
{
    struct gale_fragment frag;
    struct gale_text new_catlist = null_text, cat = null_text;
    int i;

    while ((i = gale_text_token(msg->cat, L':', &cat))) {
	if (gale_text_compare(gale_text_left(cat, 1), G_("@")))
	    new_catlist = cat_append(new_catlist, cat);
	else {
	    struct gale_text subcat = null_text;
	    int j = 0;
	    if (gale_text_compare(subs, null_text))
	      while ((j = gale_text_token(subs, L':', &subcat))) {
		if (prefix_match(cat, subcat)) {
		    new_catlist = cat_append(new_catlist, cat);
		    break;
	        }
	      }   
	    if (!j) {
		new_catlist = cat_append(new_catlist, 
					 gale_text_concat(2, G_("-"), cat));
	    }
	}
    }
    msg->cat = new_catlist;

    frag.name = gale_text_concat(2,G_("gateway/"), gale_var(G_("GALE_DOMAIN")));
    frag.type = frag_text;
    frag.value.text = G_("g3w");
    gale_group_add(&msg->data, frag);
}

struct gale_text cat_append(struct gale_text s1, struct gale_text s2)
{
    if (gale_text_compare(s1, null_text))
	s1 = gale_text_concat(2, s1, G_(":"));
    s1 = gale_text_concat(2, s1, s2);
    return s1;
}

struct gale_text extract_directed(struct gale_text catlist)
{
    struct gale_text rv = null_text, cat = null_text;
    int i;

    while ((i = gale_text_token(catlist, L':', &cat))) {
	if (!gale_text_compare(gale_text_left(cat, 1), G_("@")))
	    rv = cat_append(rv, cat);
    }
    return rv;
}

int main(int argc, char *argv[])
{
    srvinfo si1, si2;
    gale_init("g3w", argc, argv);
    if (argc != 5) {
	fprintf(stderr, "Usage: g3w server1 cats1 server2 cats2\n");
	exit(1);
    }
    gale_init_signals(source = oop_sys_source(sys = oop_sys_new()));
    si2.conn = new_link(source);
    server1 = gale_open(source, si2.conn, 
		    si1.sub = gale_text_from_local(argv[2], strlen(argv[2])), 
		    gale_text_from_local(argv[1], strlen(argv[1])), 0);
    si1.sub = extract_directed(si1.sub);
    gale_on_connect(server1, on_connected, NULL);
    gale_on_disconnect(server1, on_disconnect, NULL);
    si1.conn = new_link(source);
    server2 = gale_open(source, si1.conn, 
		    si2.sub = gale_text_from_local(argv[4], strlen(argv[4])), 
		    gale_text_from_local(argv[3], strlen(argv[3])), 0);
    si2.sub = extract_directed(si2.sub);
    gale_on_connect(server2, on_connected, NULL);
    gale_on_disconnect(server2, on_disconnect, NULL);
    link_on_message(si2.conn, on_message, &si1);
    link_on_message(si1.conn, on_message, &si2);
    source->on_signal(source,SIGTERM,on_signal,NULL);
    source->on_signal(source,SIGINT,on_signal,NULL);
    while (!is_done) oop_sys_run(sys);
    return 0;
}
